/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateRevolution.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"


//	Revolutes profileSketch on axisSketch with the specified angle, direction 
//	and material status and return the newly created revolution.
HRESULT CreateRevolution(ISketch *profileSketch, IGeometric *axisGeometric, double revolutionAngle, long revolutionDirection, long side, long materialStatus, CString revolutionName, IRevolution **pRevolution)
{

	START_METHOD("CreateRevolution")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IRevolution  *revolution = NULL;
	status = CAST(IRevolutionClass2, GetCLASS(Revolution))->CreateRevolution2(pDesign, profileSketch, axisGeometric, revolutionAngle, revolutionDirection, side, materialStatus, 0, &revolution);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, revolution);
	status = operation->SetName(revolutionName.AllocSysString());
	CHECK_RETURN_STATUS(status)
	*pRevolution = revolution;

	END_METHOD("CreateRevolution")
}
